<?php
/**
 * Mini Quick Reply
 * ( based on Evil Quick Reply )
 *
 * @package	phpBB3
 * @version 1.0.0
 * @Mini Quick Reply copyleft  (>) 2008 dyn
 * @Evil Quick Reply copyright (c) 2007 eviL3
 * @license	http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 */

/**
* @ignore
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

/**
 * This function will load everything needed for the Mini quick reply
 *
 * @param int $topic_id
 * @param int $forum_id
 * @param array $topic_data
 */
function quick_reply($topic_id, $forum_id, &$topic_data)
{
	global $template, $user, $auth, $db;
	global $phpbb_root_path, $phpEx, $config;

	// Config for the Mini quick reply
	$qr_config = array(
		'enabled'			=> true, 	// Disable it easily
		'bbcodes'			=> isset($config['mini_qr_bbcodes']) ? $config['mini_qr_bbcodes'] : true,
	);

	// do mini_qr_ prefixed of the config values exist in $config
	foreach (array_keys($qr_config) as $key)
	{
		if (isset($config['mini_qr_' . $key]))
		{
			$qr_config[$key] = $config['mini_qr_' . $key];
		}
	}

	// Check if user has reply permissions for this forum or the topic is locked (thanks damnian)
	if (!$auth->acl_get('f_reply', $forum_id) || ($topic_data['topic_status'] == ITEM_LOCKED && !$auth->acl_get('m_lock', $forum_id)) || !$qr_config['enabled'])
	{
		return;
	}

	// Hidden fields
	$s_hidden_fields = array(
		't'			=> $topic_id,
		'f'			=> $forum_id,
		'mode'		=> 'reply',
		'lastclick'	=> time(),
		'icon'		=> 0,
	);

	// Set preferences
	$reply_prefs = array(
		'disable_bbcode'	=> ($config['allow_bbcode'] && $user->optionget('bbcode')) ? false : true,
		'disable_smilies'	=> ($config['allow_smilies'] && $user->optionget('smilies')) ? false : true,
		'disable_magic_url'	=> false,
		'attach_sig'		=> ($config['allow_sig'] && $user->optionget('attachsig')) ? true: false,
		'notify'			=> ($config['allow_topic_notify'] && ($user->data['user_notify'] || isset($topic_data['notify_status']))) ? true : false,
		'lock_topic'		=> ($topic_data['topic_status'] == ITEM_LOCKED && $auth->acl_get('m_lock', $forum_id)) ? true : false,
	);

	foreach ($reply_prefs as $name => $value)
	{
		if ($value)
		{
			$s_hidden_fields[$name] = 1;
		}
	}

	// set subject
	$subject = ((strpos($topic_data['topic_title'], 'Re: ') !== 0) ? 'Re: ' : '') . censor_text($topic_data['topic_title']);
	list($s_hidden_fields['subject'], $subject) = array($subject, '');

	// Confirmation code handling ( from posting.php )
	if ($config['enable_post_confirm'] && !$user->data['is_registered'])
	{
		// Show confirm image
		$sql = 'DELETE FROM ' . CONFIRM_TABLE . "
			WHERE session_id = '" . $db->sql_escape($user->session_id) . "'
				AND confirm_type = " . CONFIRM_POST;
		$db->sql_query($sql);

		// Generate code
		$code = gen_rand_string(mt_rand(5, 8));
		$confirm_id = md5(unique_id($user->ip));
		$seed = hexdec(substr(unique_id(), 4, 10));

		// compute $seed % 0x7fffffff
		$seed -= 0x7fffffff * floor($seed / 0x7fffffff);

		$sql = 'INSERT INTO ' . CONFIRM_TABLE . ' ' . $db->sql_build_array('INSERT', array(
			'confirm_id'	=> (string) $confirm_id,
			'session_id'	=> (string) $user->session_id,
			'confirm_type'	=> (int) CONFIRM_POST,
			'code'			=> (string) $code,
			'seed'			=> (int) $seed,
		));

		$db->sql_query($sql);

		$template->assign_vars(array(
			'S_CONFIRM_CODE'	=> true,
			'CONFIRM_ID'		=> $confirm_id,
			'CONFIRM_IMAGE'		=> '<img src="' . append_sid("{$phpbb_root_path}ucp.$phpEx", 'mode=confirm&amp;id=' . $confirm_id . '&amp;type=' . CONFIRM_POST) . '" alt="" title="" />',
		));
	}

	// new RC6/RC7 stuff
	add_form_key('posting');

	// Page title & action URL, include session_id for security purpose
	$s_action = append_sid("{$phpbb_root_path}posting.$phpEx", false, true, $user->session_id);

  // Add other bbcodes ( from posting.php )
  $bbcode_status		= ($config['allow_bbcode'] && $auth->acl_get('f_bbcode', $forum_id)) ? true : false;
	$img_status				= ($bbcode_status && $auth->acl_get('f_img', $forum_id)) ? true : false;
	$url_status				= ($config['allow_post_links']) ? true : false;
	$flash_status			= ($bbcode_status && $auth->acl_get('f_flash', $forum_id) && $config['allow_post_flash']) ? true : false;
	$quote_status			= ($auth->acl_get('f_reply', $forum_id)) ? true : false;

	// Assign template variables
	$template->assign_vars(array(
		'S_QR_HIDDEN_FIELDS'	=> build_hidden_fields($s_hidden_fields),
		'S_QR_POST_ACTION'		=> $s_action,
		'S_QR_ENABLED'				=> $qr_config['enabled'],
		'S_BBCODE_IMG'				=> $img_status,
		'S_BBCODE_URL'				=> $url_status,
		'S_LINKS_ALLOWED'			=> $url_status,
		'S_BBCODE_FLASH'			=> $flash_status,
		'S_BBCODE_QUOTE'			=> $quote_status
	));

	// enable bbcodes only when board allows them
	// comment out display_custom_bbcodes(); if you don't want custom bbcodes
	if ($bbcode_status && $qr_config['bbcodes'])
	{
		$user->add_lang('posting');
		$template->assign_var('S_BBCODE_ALLOWED', true);
		display_custom_bbcodes();
	}
}

?>