<?php
/*-----------------------------------------------------------------------------
    GOLDBIX1 ->2 CONVERTOR for phpBB 3
  ----------------------------------------------------------------------------
convertor.php
    Generation Date:12:35  17/08/28
  ----------------------------------------------------------------------------
  This file is released under the GNU General Public License Version 2.
-----------------------------------------------------------------------------*/

define('IN_PHPBB', true);
$phpbb_root_path = './';
$phpEx = substr(strrchr(__FILE__, '.'), 1);
include_once($phpbb_root_path . 'common.'.$phpEx);
include_once($phpbb_root_path . '/includes/functions_install.'.$phpEx);
include_once($phpbb_root_path . '/includes/functions_convert.'.$phpEx);
include_once($phpbb_root_path . 'includes/bbcode.' . $phpEx);
include($phpbb_root_path . 'includes/message_parser.' . $phpEx);

// Session management
$user->session_begin();
$auth->acl($user->data);
$user->setup('acp/common');

if ($user->data['user_id'] == ANONYMOUS)
{
	login_box("convertor.$phpEx", $user->lang['LOGIN_ADMIN'], $user->lang['LOGIN_ADMIN_SUCCESS']);
}

if (!$auth->acl_get('a_'))
{
	trigger_error($user->lang['NO_ADMIN']);
}

$mod = array(
	'name'			=>	'GoldBox',
	'version'		=>	'2.0.1',
	'copy_year'		=>	'1428 H',
	'author'		=>	'Saanina',
	'website'		=>	'http://www.phpbbarabia.com',
	'sitename'		=>	'phpbbarabia',
	'prev_version'	=>	'2.0.1',
);


$page_title = $mod['name'] . ' Convertor';
$action = request_var('action', '');

$version_string = $of_name = $for_name = '';
if( !empty($mod['name']) )
{
	$of_name  = ' ' . $mod['name'];
	$for_name = ' ' . $mod['name'];
}



$page_head = <<<EOH
<html dir="rtl">
<head>
<title>$page_title</title>
<style type="text/css">
<!--
body
{
	color: black;
	background-color: silver;
	margin: 0;
	padding: 0;
	font-size: 15px;
	font-family:Tahoma, Arial, Helvetica, sans-serif;
}

a
{
	background-color: inherit;
	text-decoration: none;
	font-size: 2em;
}

a:hover
{
	color: green;
	background-color: inherit;
	text-decoration: underline;
}

div#header
{
	width: 100%;
	color: black;
	background-position: right bottom;
	border: none;
	margin-top: 0.4em;
	margin-bottom: 0.5em;
}

#logo
{
	font-size: 1.8em;
	font-weight: bold;
	padding-left: 0.5em;
}

#logo a, #logo a:hover
{
	color: saddlebrown;
	font-size: 1em;
}

#footer
{
	clear: both;
	border: none;
	border-top: 1px solid saddlebrown;
	margin: 0;
	padding: 0.3em;
	font-size: 0.7em;
	text-align: left;
}

#content
{
	background: ivory;
	border-top: 1px solid saddlebrown;
	margin-top: 0;
	padding: 0.5em 1em 0.1em;
	text-align: justify;
}

p, ul
{
	font-size: 0.8em;
}

.error
{
	font-weight: bold;
	color: red;
}

.success
{
	font-weight: bold;
	color: green;
}
-->
</style>
</head>
<body>
<div id="header">
	<div id="logo">$page_title</div>
</div>
<div id="content">
<p>
	   {$page_title}.
</p>

EOH;

$page_tail = <<<EOH
	</div>
	<div id="footer">
		{$mod['name']} Copyright &copy; {$mod['copy_year']} by <a href="{$mod['website']}" title="   ">{$mod['author']}</a>
	</div>
</body>
</html>
EOH;

$url_append = $phpEx . '?sid=' . $user->data['session_id'];
$page_postaction = <<<EOH
	</p>	
	<p class="alert">    <a href="adm/index.$url_append">   </a>          ...</p>
EOH;

$results = array();
$db_errors = FALSE;
$db->sql_return_on_error(true);

@set_time_limit(3000);
$posts_default=500;




###
function converts($message, $uid)
{
	static $origx, $replx, $str_from, $str_to;

		
		$origx = array(
			'#\[poet[^\]]+\](.*?)\[/poet\]#is',
			'#\[cell[^\]]+\](.*?)\[/cell\]#is',
			'#\[table[^\]]+\](.*?)\[/table\]#is',
			'#\[marq[^\]]+\](.*?)\[/marq\]#is',
			'#\[video[^\]]+\](.*?)\[/video\]#is',
			'#\[flash[^\]]+\](.*?)\[/flash\]#is'			
		);

		$replx = array(
			'\1',
			'\1',
			'\1',
			'\1',
			'\1',
			'\1'
		);
		
		$str_from = array(
			'[stream]',	'[/stream]', // [url]
			'[eng]',	'[/eng]', // english
			'[hr]',		'[/hr]', // none
			'[twh]',	'[/twh]',  //glow
			'[shar]',	'[/shar]', // s
			'[priq]',	'[/priq]', // none
			'[saa]',	'[/saa]', // wave
			'[ram]',	'[/ram]' ,//rams
			'[fot]',	'[/fot]' ,
			'[center]',	'[/center]' //rams
		);

		$str_to = array(
			"[url:".$uid."]",	"[/url:".$uid."]",
			"[english:".$uid."]","[/english:".$uid."]",
			"\n",		'',
			"[glint:".$uid."]",	"[/glint:".$uid."]",
			"[s:".$uid."]",		"[/s:".$uid."]",
			'',			'',
			"[wave:".$uid."]",	"[/wave:".$uid."]",
			"[rams:".$uid."]",	"[/rams:".$uid."]",
			'',	'',
			'',	'' 
		);

		for ($i = 0; $i < sizeof($str_from); ++$i)
		{
			$origx[] = '#\\' . str_replace(']', '\\]', $str_from[$i]) . '#is';
			$replx[] = $str_to[$i];
		}


	$message = preg_replace($origx, $replx, $message);
	

	return $message;

}

##

function add_result($item, $msg = '')
{
	$str = '<li>' . htmlspecialchars($item) . '<br /><span class="success">'.$msg;
	$str .= '</span></li>';
	return $str;
}
function msg($msg)
{
	$msg = '  '.$msg.'  ';
	echo $msg;
}

$page_text = '';
echo $page_head;

if( $action != "convert")
{
	$page_text = <<<EOH
	<p class="alert">   ,         .            .</p>
	<p>
EOH;

		$page_text .= <<<EOH
	<ul>
		<li><a href="convertor.$url_append&amp;action=convert"><b>     </b>
		<br />
		<span style='font-size:14px'>       ..!.</span>
		</a></li>
EOH;


	$page_text .= <<<EOH
	</ul>
	</p>
EOH;

}
if ( $action == "convert")
{
	///////
		$sql = "SELECT COUNT(post_id) FROM " . $table_prefix . "posts";
		
		if (!($result = $db->sql_query($sql)))
		{
		add_result($sql, 'Unable to retrieve post count' );
		exit();
		}
		
		$number = $db->sql_fetchrow($result);
		$postsnum = $number['COUNT(post_id)'];
		$loopnum=intval($postsnum / $posts_default);			    // how many loop he needs to create 
		$posts_left=($postsnum % $posts_default);					// how many posts are left from divizion
		$db->sql_freeresult($result);
		
		Flush(); 

		if ($posts_left <> 0 ){	 
			$loopnum++;									// one extra loop for the posts_left 
		} 
 
		$posts_loc=0; 
		
		
		// Now adjust posts
		$message_parser = new parse_message();
		$message_parser->mode = 'post';
		$message_parser->bbcode_init();
		 
		for ($y = 1; $y <= $loopnum; $y++)		// does a loop as long as it has to 
		{ 
		
		Flush(); 
		
			if ($y <> $loopnum) 
			{ 
				$sql = "SELECT * FROM " . $table_prefix . "posts LIMIT $posts_loc,$posts_default "; // 500 topics 
			}
			else
			{
				if ($posts_left == 0)
				{
					$posts_left = $posts_default;
				}
				$sql = "SELECT * FROM " . $table_prefix . "posts LIMIT $posts_loc,$posts_left ";    // on the last pass only what is left 

			}
			$result = $db->sql_query($sql); 
			
			
			if(!$result = $db->sql_query($sql)) 
			{ 
			add_result($sql, $db->sql_error() );
			}
			
			//problem here
			$posts_count = $db->sql_affectedrows($result); 
			while ($row = $db->sql_fetchrow($result)) 
			{
				$posts_data[] = $row;
			}	
			//$posts_data = $db->sql_fetchrow($result);   <<<--- bad code 
			$db->sql_freeresult($result);
			
 	
			flush(); 
			
			for ($i = 0; $i < $posts_count; $i++) 
			{ 
			
			//code under this comment took many days to be like this ..
			
				//$pid 		= $posts_data[$i]['post_id']; 
				//$message 	= $posts_data[$i]['post_text'];
				//$uid	= $posts_data[$i]['bbcode_uid'];
				
				$posts_data[$i]['post_text']= converts($posts_data[$i]['post_text'], $posts_data[$i]['bbcode_uid']);	
		
		//eeeeeeeeeeeeeeeeeeeeee
				decode_message($posts_data[$i]['post_text'], $posts_data[$i]['bbcode_uid']);
				$message_parser->message = &$posts_data[$i]['post_text'];
				$bbcodeId = $message_parser->bbcode_uid;
				$message_parser->prepare_bbcodes();
				$message_parser->parse_bbcode();
				$bitfield = $message_parser->bbcode_bitfield;
		//eeeeeeeeeeeeeeeeeeeeee
				//unset($uid);unset($message);

				//very important
			//	$uid	= $posts_data[$i]['bbcode_uid'];
				//$bitfield	= $posts_data[$i]['bbcode_bitfield']; // << pronlem here now
				
				

				//$message1 = converts($message, $uid);
				
				
				//$message = utf8_normalize_nfc($message);
				//$bitfield = $options = ''; // will be modified by generate_text_for_storage
				//$allow_bbcode = $allow_urls = $allow_smilies = true;
				//$message_parser->bbcode_uid = $uid;
				
				//$options = '';
				//generate_text_for_storage($message, $uid, $bitfield, $options, true, true, true);

				//echo  $uid;
			//	$bbcode = new bbcode(base64_encode($bitfield[$i]));
			//	$bbcode->bbcode_second_pass($message, $uid, $bitfield);
				
				
				$po_sql = array(
				'post_text'			=> $posts_data[$i]['post_text'],
				'bbcode_uid'        => $bbcodeId,
				'bbcode_bitfield'   => $bitfield,
				);
				
				$sqql = $db->sql_query('UPDATE ' . $table_prefix . 'posts  SET ' . $db->sql_build_array('UPDATE', $po_sql) . '
						WHERE post_id = ' . $posts_data[$i]['post_id']);
				if ($sqql)
				{
				msg("[<span style='color=#33FF66;'>" . $posts_data[$i]['post_id']. "</span>");
				}
				else
				{
				msg("<span style='color=red;'>...error ->" . $posts_data[$i]['post_id'] . "</span>");
					$sql_error = $db->sql_error(); 
					print $sql_error['code'] .": ". $sql_error['message']. "<br>\n"; 
				}
			}

			$posts_loc=$posts_loc+$posts_default; 
			
		
		}#for
		
msg("<br /><span style='color=green;'> finish all preparing posts for goldbox2</span>");
}


echo $page_text;
echo $page_tail;
?>