<?php
# Zoints Forum Ban
# Copyright 2006 Zoints Inc.
#
# This code may not be redistributed without prior written consent.
#

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('banning');
$specialtemplates = array('bbcodecache', 'smiliecache');

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_forumban.php');

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'view';
}

// ############################# LOG ACTION ###############################
$vbulletin->input->clean_array_gpc('r', array(
	'userid'	 => TYPE_UINT,
	'forumid'	 => TYPE_UINT,
	'forumbanid' => TYPE_UINT
));

log_admin_action(
	iif($vbulletin->GPC['userid'] != 0, 'user id = ' . $vbulletin->GPC['userid'], '') .
	iif($vbulletin->GPC['forumid'] != 0, ' forum id = ' . $vbulletin->GPC['forumid'], '') .
	iif($vbulletin->GPC['forumbanid'] != 0, ' forumban id = ' . $vbulletin->GPC['forumbanid'], '')
);


if (!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']))
{
	$fbimodcache = array();
	$canmod = $db->query_read("SELECT userid, forumid, canforumban FROM " . TABLE_PREFIX . "moderator WHERE userid = " . $vbulletin->userinfo['userid']);
	while ($mod = $db->fetch_array($canmod))
	{
		$fbimodcache[$mod['forumid']] = $mod['canforumban'];
	}
}


// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['zointsforumban']);

if (!$vbulletin->options['zointsforumban_enable'])
{
	print_table_start(false);
	print_table_header($vbphrase['forumban_forumban_not_enabled']);
	print_description_row($vbphrase['forumban_forumban_not_enabled']);
	print_table_footer();
	print_cp_footer();
	exit;
}


if (!$vbulletin->options['enableaccess'])
{
	print_table_start(false);
	print_table_header($vbphrase['forumban_access_masks_not_enabled']);
	if ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel'])
	{
		print_description_row(construct_phrase($vbphrase['forumban_access_masks_not_enabled_detail'], $vbulletin->config['Misc']['admincpdir']));
	}
	else
	{
		print_description_row($vbphrase['forumban_access_masks_not_enabled_detail_nonadmin']);
	}
	print_table_footer();
}

if ($_REQUEST['do'] == 'view')
{
	print_form_header('forumban', 'ban');
	print_table_header($vbphrase['forumban_user_from_this_forum']);
	print_forumban_chooser($vbphrase['forum'], 'forumid');
	print_submit_row($vbphrase['go'], false);

	print_form_header('forumban', 'forum');
	print_table_header($vbphrase['view_bans_for_this_forum']);
	print_forumban_chooser($vbphrase['forum'], 'forumid');
	print_submit_row($vbphrase['view'], false);
	
	# X latest bans
	if ($vbulletin->options['zointsforumban_latestbans'] > 0)
	{
		print_table_start();
		print_table_header(construct_phrase($vbphrase['forumban_x_latest_bans'], $vbulletin->options['zointsforumban_latestbans']),7);
		print_cells_row(array(
			$vbphrase['user'],
			$vbphrase['admin'],
			$vbphrase['forum'],
			$vbphrase['forumban_release_date'],
			$vbphrase['forumban_comment_plain'],
			$vbphrase['view'],
			$vbphrase['forumban_unban']
		),1);
		
		$latestbans = $db->query_read("
			SELECT forumban.*, user.username, admin.username admin, forum.title
			FROM " . TABLE_PREFIX . "forumban forumban
			LEFT JOIN " . TABLE_PREFIX . "access access ON(access.forumid = forumban.forumid AND access.userid = forumban.userid)
			LEFT JOIN " . TABLE_PREFIX . "user user ON(user.userid = forumban.userid)
			LEFT JOIN " . TABLE_PREFIX . "user admin ON(admin.userid = forumban.adminid)
			LEFT JOIN " . TABLE_PREFIX . "forum forum ON(forum.forumid = forumban.forumid)
			WHERE access.accessmask = 0
			ORDER BY dateline DESC
			LIMIT " . $vbulletin->options['zointsforumban_latestbans'] . "
		");
		
		while ($forumban = $db->fetch_array($latestbans))
		{
			if (!can_forumban($forumban['forumid']))
			{
				continue;
			}
		
			if ($forumban['release'])
			{
				$release = vbdate($vbulletin->options['dateformat'], $forumban['release'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['release']);
			}
			else
			{
				$release = $vbphrase['never'];
			}
			$cells = array();
			$cells[] = $forumban['username'];
			$cells[] = $forumban['admin'];
			$cells[] = $forumban['title'];
			$cells[] = $release;
			$cells[] = substr($forumban['message'], 0, 75) . iif(strlen($forumban['message']) > 75, '...');
			$cells[] = construct_link_code($vbphrase['view'], "forumban.php?do=viewban&amp;forumbanid=" . $forumban['forumbanid']);
			$cells[] = construct_link_code('X', "forumban.php?do=unban&amp;forumbanid=" . $forumban['forumbanid']);
			print_cells_row($cells);
		}
		
		print_table_footer();
	}
	
	
	
}

if ($_REQUEST['do'] == 'forum')
{
	$foruminfo = fetch_foruminfo($vbulletin->GPC['forumid']);
	
	if (!$foruminfo)
	{
		eval(print_stop_message('invalid_forum_specified'));
	}
	
	if (!can_forumban($foruminfo['forumid']))
	{
		eval(print_stop_message('no_permission'));
	}
	
	print_table_start();
	print_table_header(construct_phrase($vbphrase['forumban_users_banned_from_forum_x'], $foruminfo['title']),5);
	print_cells_row(array($vbphrase['user'], $vbphrase['forumban_release_date'], $vbphrase['forumban_comment_plain'], $vbphrase['view'], $vbphrase['forumban_unban']),1);
	
	$forumbans = $db->query_read("
		SELECT forumban.*, user.username, admin.username admin
		FROM " . TABLE_PREFIX . "forumban forumban
		LEFT JOIN " . TABLE_PREFIX . "access access ON(access.forumid = forumban.forumid AND access.userid = forumban.userid)
		LEFT JOIN " . TABLE_PREFIX . "user user ON(user.userid = forumban.userid)
		LEFT JOIN " . TABLE_PREFIX . "user admin ON(admin.userid = forumban.adminid)
		WHERE forumban.forumid = $foruminfo[forumid] AND access.accessmask = 0
		ORDER BY dateline DESC
	");
	while ($forumban = $db->fetch_array($forumbans))
	{
		if ($forumban['release'])
		{
			$release = vbdate($vbulletin->options['dateformat'], $forumban['release']) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['release']);
		}
		else
		{
			$release = $vbphrase['never'];
		}
	
		$cells = array();
		$cells[] = $forumban['username'];
		$cells[] = $release;
		$cells[] = substr($forumban['message'], 0, 75) . iif(strlen($forumban['message']) > 75, '...');
		$cells[] = construct_link_code($vbphrase['view'], "forumban.php?do=viewban&amp;forumbanid=" . $forumban['forumbanid']);
		$cells[] = construct_link_code('X', "forumban.php?do=unban&amp;forumbanid=" . $forumban['forumbanid']);
		print_cells_row($cells);
	}
	print_table_footer();
	
	print_form_header('forumban', 'doban');
	print_table_header(construct_phrase($vbphrase['forumban_ban_user_from_x'], $foruminfo['title']));
	print_forumban_chooser($vbphrase['forum'], 'forumid', $foruminfo['forumid']);
	print_input_row($vbphrase['username'], 'username');
	print_forumban_time_row($vbphrase['forumban_release_date'], 'release');
	print_label_row('', $vbphrase['forumban_or']);
	print_label_row($vbphrase['forumban_length'], '<input type="text" name="length" class="bginput" size="8" /> ' . 
		'<select class="bginput" name="lengthtype">' . construct_select_options(array(
			'hours'		=> $vbphrase['forumban_hours'],
			'days'		=> $vbphrase['days'],
			'weeks'		=> $vbphrase['weeks'],
			'months'	=> $vbphrase['months'],
			'years'		=> $vbphrase['years']
		)) . '</select>');
	if ($vbulletin->options['zointsforumban_silentban'])
	{
		print_yes_no_row($vbphrase['forumban_silent_ban'], 'silentban', 0);
	}
	print_textarea_row($vbphrase['forumban_comment'], 'comment', '', 8, 60);
	print_textarea_row($vbphrase['forumban_admin_comment'], 'admincomment', '', 8, 60);
	
	
	print_submit_row($vbphrase['forumban_ban']);
}

if ($_REQUEST['do'] == 'viewban')
{
	$forumban = $db->query_first("
		SELECT forumban.*, user.username, admin.username admin, forum.title, access.forumid f2, access.userid u2, accessmask
		FROM " . TABLE_PREFIX . "forumban forumban
		LEFT JOIN " . TABLE_PREFIX . "access access ON(access.forumid = forumban.forumid AND access.userid = forumban.userid)
		LEFT JOIN " . TABLE_PREFIX . "user user ON(user.userid = forumban.userid)
		LEFT JOIN " . TABLE_PREFIX . "user admin ON(admin.userid = forumban.adminid)
		LEFT JOIN " . TABLE_PREFIX . "forum forum ON(forum.forumid = forumban.forumid)
		WHERE forumbanid = " . $vbulletin->GPC['forumbanid'] . "
			AND access.accessmask = 0
	");
	
	if (!$forumban)
	{
		eval(print_stop_message('invalid_forumban_specified'));
	}
	
	if (!can_forumban($forumban['forumid']))
	{
		eval(print_stop_message('no_permission'));
	}
	
	forumban_bbcode_fix();
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	
	print_table_start();
	print_table_header($vbphrase['viewing_forumban']);
	print_column_style_code(array('width: 20%','width: 80%'));
	print_label_row($vbphrase['user'], $forumban['username']);
	print_label_row($vbphrase['admin'], $forumban['admin']);
	print_label_row($vbphrase['forum'], $forumban['title']);
	print_label_row($vbphrase['forumban_ban_date'], vbdate($vbulletin->options['dateformat'], $forumban['dateline'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['dateline']));
	if ($forumban['release'])
	{
		print_label_row($vbphrase['forumban_release_date'], vbdate($vbulletin->options['dateformat'], $forumban['release'], true) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['release']));
	}
	else
	{
		print_label_row($vbphrase['forumban_release_date'], $vbphrase['never']);
	}
	print_label_row($vbphrase['forumban_comment_plain'], $bbcode_parser->parse($forumban['message']));
	print_label_row($vbphrase['forumban_admin_comment_plain'], $bbcode_parser->parse($forumban['admincomment']));
	print_table_footer();
	
	print_form_header('forumban', 'unban');
	construct_hidden_code('forumbanid', $forumban['forumbanid']);
	print_submit_row($vbphrase['forumban_unban'], false);
}

if ($_REQUEST['do'] == 'unban' OR $_POST['do'] == 'dounban')
{
	$forumban = $db->query_first("
		SELECT forumban.*, user.username, admin.username admin, forum.title
		FROM " . TABLE_PREFIX . "forumban forumban
		LEFT JOIN " . TABLE_PREFIX . "access access ON(access.forumid = forumban.forumid AND access.userid = forumban.userid)
		LEFT JOIN " . TABLE_PREFIX . "user user ON(user.userid = forumban.userid)
		LEFT JOIN " . TABLE_PREFIX . "user admin ON(admin.userid = forumban.adminid)
		LEFT JOIN " . TABLE_PREFIX . "forum forum ON(forum.forumid = forumban.forumid)
		WHERE forumbanid = " . $vbulletin->GPC['forumbanid'] . "
			AND access.accessmask = 0
	");
	
	if (!$forumban)
	{
		eval(print_stop_message('invalid_forumban_specified'));
	}
	
	if (!can_forumban($forumban['forumid']))
	{
		eval(print_stop_message('invalid_forumban_specified'));
	}
	
	if (!$vbulletin->options['zointsforumban_modoverwrite'] AND 
		!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']) AND 
		$forumban['adminid'] != $vbulletin->userinfo['userid']
	)
	{
		eval(print_stop_message('no_permission'));
	}
	
	if ($_POST['do'] == 'dounban')
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "forumban WHERE forumbanid = $forumban[forumbanid]");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "access WHERE forumid = $forumban[forumid] AND userid = $forumban[userid] AND accessmask = 0");
		
		
		$count = $db->query_first("SELECT COUNT(*) count FROM " .  TABLE_PREFIX . "access WHERE userid = $forumban[userid]");
		if ($count['count'] == 0)
		{
			$userinfo = fetch_userinfo($forumban['userid']);
			$userdm = datamanager_init('User', $vbulletin, ERRTYPE_SILENT);
			$userdm->set_existing($userinfo);
			$userdm->set_bitfield('options', 'hasaccessmask', false);
			$userdm->save();
		}
		
		
		if ($vbulletin->options['zointsforumban_notify_unban'] AND !empty($vbulletin->options['zointsforumban_unban_pmtitle']) AND !empty($vbulletin->options['zointsforumban_unban_pm']))
		{
			$messagetitle = $vbulletin->options['zointsforumban_unban_pmtitle'];
			$message = $vbulletin->options['zointsforumban_unban_pm'];
			
			$messrepl = array(
				'userid'	=> $forumban['userid'],
				'user'		=> $forumban['username'],
				'admin'		=> $forumban['admin'],
				'release'	=> vbdate($vbulletin->options['dateformat'], $forumban['release']) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['release']),
				'date'		=> vbdate($vbulletin->options['dateformat'], $forumban['dateline']) . ' ' . vbdate($vbulletin->options['timeformat'], $forumban['dateline']),
				'reason'	=> $forumban['comment'],
				'forum'		=> $forumban['title'],
				'forumid'	=> $forumban['forumid']
			);
			
			foreach ($messrepl as $find => $replace)
			{
				$message = str_replace('{' . $find . '}', $replace, $message);
				if ($find == 'user' OR $find == 'release' OR $find == 'forum' OR $find == 'date')
				{
					$messagetitle = str_replace('{' . $find . '}', $replace, $messagetitle);
				}
			}
		
			forumban_bbcode_fix();
			require_once(DIR . '/includes/class_bbcode.php');
			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
			
			$pmpermissions = array('adminpermissions' => 2);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY); 
			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->set('title', $messagetitle);
			$pmdm->set('message', $message);
			# send even if pm box is full
			$pmdm->set_recipients($forumban['username'], $pmpermissions);
			$pmdm->set('dateline', TIMENOW);
			$pmdm->set_info('savecopy', 1);
			$pmdm->save();
		}
		
		define('CP_REDIRECT', "forumban.php?do=forum&forumid=" . $forumban['forumid']);
		print_stop_message('forumban_unbanned_x_successfully_from_y', $forumban['username'], $forumban['title']);
	}
	else
	{
		print_form_header('forumban', 'dounban');
		construct_hidden_code('forumbanid', $vbulletin->GPC['forumbanid']);
		print_table_header(construct_phrase($vbphrase['are_you_sure_you_want_to_unban_x_from_y'], $forumban['username'], $forumban['title']));
		print_description_row(construct_phrase($vbphrase['are_you_sure_you_want_to_unban_x_from_y'], $forumban['username'], $forumban['title']));
		print_submit_row($vbphrase['yes'], false, 2, $vbphrase['no']);
	}
}


if ($_REQUEST['do'] == 'ban')
{
	$vbulletin->input->clean_gpc('r', 'username', TYPE_STR);
	
	if ($vbulletin->GPC['userid'])
	{
		$user = fetch_userinfo($vbulletin->GPC['userid']);
		$vbulletin->GPC['username'] = $user['username'];
	}
	
	print_form_header('forumban', 'doban');
	print_table_header(construct_phrase($vbphrase['forumban_ban_user_from_x'], $foruminfo['title']));
	print_forumban_chooser($vbphrase['forum'], 'forumid', $vbulletin->GPC['forumid']);
	print_input_row($vbphrase['username'], 'username', $vbulletin->GPC['username']);
	print_forumban_time_row($vbphrase['forumban_release_date'], 'release');
	print_label_row('', $vbphrase['forumban_or']);
	print_label_row($vbphrase['forumban_length'], '<input type="text" name="length" class="bginput" size="8" /> ' . 
		'<select class="bginput" name="lengthtype">' . construct_select_options(array(
			'hours'		=> $vbphrase['forumban_hours'],
			'days'		=> $vbphrase['days'],
			'weeks'		=> $vbphrase['weeks'],
			'months'	=> $vbphrase['months'],
			'years'		=> $vbphrase['years']
		)) . '</select>');
	if ($vbulletin->options['zointsforumban_silentban'])
	{
		print_yes_no_row($vbphrase['forumban_silent_ban'], 'silentban', 0);
	}
	print_textarea_row($vbphrase['forumban_comment'], 'comment', '', 8, 60);
	print_textarea_row($vbphrase['forumban_admin_comment'], 'admincomment', '', 8, 60);
	
	
	print_submit_row($vbphrase['forumban_ban']);
}

if ($_POST['do'] == 'doban')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'username'		=> TYPE_STR,
		'release'		=> TYPE_ARRAY_INT,
		'length'		=> TYPE_UINT,
		'lengthtype'	=> TYPE_STR,
		'silentban'		=> TYPE_BOOL,
		'comment'		=> TYPE_STR,
		'admincomment'	=> TYPE_STR,
		'confirmation'	=> TYPE_BOOL,
		'releasetime'	=> TYPE_UINT
	));
	
	$user = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE username = '" . $db->escape_string(htmlspecialchars_uni($vbulletin->GPC['username'])) . "'");
	
	if (!$user)
	{
		eval(print_stop_message('invalid_user_specified'));
	}
	
	$nodelete = explode(',', $vbulletin->config['SpecialUsers']['undeletableusers']);
	if (in_array($user['userid'], $nodelete))
	{
		print_stop_message('user_is_protected_from_alteration_by_undeletableusers_var');
	}
	
	if (!$vbulletin->GPC['forumid'])
	{
		eval(print_stop_message('invalid_forum_specified'));
	}
	
	$forum = fetch_foruminfo($vbulletin->GPC['forumid']);

	if (!$forum['forumid'])
	{
		eval(print_stop_message('invalid_forum_specified'));
	}

	if (!can_forumban($forum['forumid']))
	{
		eval(print_stop_message('no_permission'));
	}
	
	
	$existing = $db->query_first("
		SELECT forumban.*, user.username admin
		FROM " . TABLE_PREFIX . "forumban forumban
		LEFT JOIN " . TABLE_PREFIX . "user user ON(user.userid = forumban.adminid)
		WHERE forumid = $forum[forumid]
			AND forumban.userid = " . $user['userid'] . "
	");
	
	if (!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['ismoderator']) AND !$vbulletin->options['zointsforumban_modoverwrite'])
	{
		eval(print_stop_message('forumban_already_banned_from_x_by_y', $forum['title'], $user['admin']));
	}
	
	if (!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND !$vbulletin->options['zointsforumban_adminoverwrite'])
	{
		$existing = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "access access
			LEFT JOIN " . TABLE_PREFIX . "forumban forumban ON(access.forumid = forumban.forumid AND access.userid = forumban.userid)
			WHERE access.forumid = $forum[forumid]
				AND access.userid = " . $user['userid'] . "
				AND forumban.forumid IS NULL
		");
		
		if ($existing)
		{
			eval(print_stop_message('forumban_already_set_by_admin'));
		}
	}
	
	$release = 0;
	if ($vbulletin->GPC['length'])
	{
		switch($vbulletin->GPC['lengthtype'])
		{
			case 'years':
				$seconds = 31536000;
				break;
			case 'months':
				$seconds = 2592000;
				break;
			case 'weeks':
				$seconds = 604800;
				break;
			case 'days':
				$seconds = 86400;
				break;
			default:
				$seconds = 3600;
		}
		$release = TIMENOW + ($vbulletin->GPC['length'] * $seconds);
	}
	else if ($vbulletin->GPC['release']['day'] > 0 AND $vbulletin->GPC['release']['month'] > 0 AND $vbulletin->GPC['release']['year'] > 0 AND $vbulletin->GPC['release']['hour'] > -1)
	{
		require_once(DIR . '/includes/functions_misc.php');
		$release = vbmktime($vbulletin->GPC['release']['hour'], 0, 0, $vbulletin->GPC['release']['month'], $vbulletin->GPC['release']['day'], $vbulletin->GPC['release']['year']);
	}
	else if ($vbulletin->GPC['releasetime'])
	{
		$release = $vbulletin->GPC['releasetime'];
	}
	
	if ($release !== 0 AND $release < TIMENOW)
	{
		eval(print_stop_message('forumban_release_time_not_in_future'));
	}
	
	forumban_bbcode_fix();
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
	
	$messagereplacement = array(
		'userid'	=> $user['forumid'],
		'user'		=> $user['username'],
		'release'	=> vbdate($vbulletin->options['dateformat'], $release) . " " . vbdate($vbulletin->options['timeformat'], $release),
		'reason'	=> $vbulletin->GPC['comment'],
		'forumid'	=> $forum['forumid'],
		'forum'		=> $forum['title'],
		'admin'		=> $vbulletin->userinfo['username']
	);
	
	$message = $vbulletin->options['zointsforumban_message'];
	$messagetitle = $vbulletin->options['zointsforumban_pmtitle'];
	
	foreach ($messagereplacement as $find => $replace)
	{
		$message = str_replace('{' . $find . '}', $replace, $message);
		if ($find == 'user' OR $find == 'forum' OR $find == 'release')
		{
			$messagetitle = str_replace('{' . $find . '}', $replace, $messagetitle);
		}
	}
	
	if (!$vbulletin->GPC['confirmation'])
	{
		print_form_header('forumban','doban');
		print_column_style_code(array('width: 20%', 'width: 80%'));
		print_table_header(construct_phrase($vbphrase['are_you_sure_you_want_to_forumban_x'], $user['username']));
		construct_hidden_code('confirmation', 1);
		construct_hidden_code('forumid', $forum['forumid']);
		construct_hidden_code('username', $user['username']);
		construct_hidden_code('releasetime', $release);
		construct_hidden_code('silentban', $vbulletin->GPC['silentban']);
		construct_hidden_code('comment', $vbulletin->GPC['comment']);
		construct_hidden_code('admincomment', $vbulletin->GPC['admincomment']);
		
		print_label_row($vbphrase['user'], construct_link_code($user['username'], $vbulletin->options['bburl'] . '/member.php?u=' . $user['userid']));
		print_label_row($vbphrase['forumban_from_forum'], $forum['title']);
		if ($release)
		{
			print_label_row($vbphrase['forumban_release_date'], vbdate($vbulletin->options['dateformat'], $release, true) . " " . vbdate($vbulletin->options['timeformat'], $release));
		}
		else
		{
			print_label_row($vbphrase['forumban_release_date'], $vbphrase['never']);
		}
		if ($vbulletin->options['zointsforumban_silentban'])
		{
			print_label_row($vbphrase['forumban_silent_ban'], $vbulletin->GPC['silentban'] ? $vbphrase['yes'] : $vbphrase['no']);
		}
		
		print_label_row($vbphrase['forumban_comment'], $bbcode_parser->parse($vbulletin->GPC['comment']));
		print_label_row($vbphrase['forumban_admin_comment'], $bbcode_parser->parse($vbulletin->GPC['admincomment']));
		
		print_label_row($vbphrase['forumban_message_preview'], $bbcode_parser->parse($message));
		
		print_submit_row($vbphrase['yes'], false, 2, $vbphrase['no']);
	}
	else
	{
		$db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "access 
				(userid, forumid, accessmask)
			VALUES 
				($user[userid],$forum[forumid],0)
		");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "forumban WHERE userid = $user[userid] AND forumid = $forum[forumid]");
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "forumban
				(userid, forumid, adminid, dateline, `release`, message, admincomment)
			VALUES (
				$user[userid],
				$forum[forumid],
				" . $vbulletin->userinfo['userid'] . ",
				" .  TIMENOW . ",
				$release,
				'" . $db->escape_string($vbulletin->GPC['comment']) . "',
				'" . $db->escape_string($vbulletin->GPC['admincomment']) . "'
		)");
		
		$userdm = datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);
		$userdm->set_existing($user);
		$userdm->set_bitfield('options', 'hasaccessmask', true);
		$userdm->save();
		
		
		if (!($vbulletin->options['zointsforumban_silentban'] AND $vbulletin->GPC['silentban']))
		{
			$pmpermissions = array('adminpermissions' => 2);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY); 
			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->set('title', $messagetitle);
			$pmdm->set('message', $message);
			# send even if pm box is full
			$pmdm->set_recipients($user['username'], $pmpermissions);
			$pmdm->set('dateline', TIMENOW);
			$pmdm->set_info('savecopy', 1);
			$pmdm->save();
		}
		
		define('CP_REDIRECT', "forumban.php?do=forum&forumid=" . $forum['forumid']);
		print_stop_message('forumbanned_user_x_successfully', $user['username']);
	}
}

print_cp_footer();
?>