// **********************************
//           5.00
//  /    
//        
// **********************************
var highlightColor = "deepskyblue";
var colorBoxHTML;

function ifPressed(c, v1, v2) {
		if (c.style.backgroundColor==highlightColor)
			return v1;
		else if (v2)
			return v2;
		else
			return "";
}

function getValue(t, p) {
	var r = new RegExp("([ \']|^)" + t + "[ ]*=[ ]*\'[^\']*\'", "i");
	var m = p.match(r);
	if (!m) {
	  r = new RegExp("([ \']|^)" + t + "[ ]*=[ ]*[^\' ]*([ ]|$)", "i");
	  m = p.match(r);
	  if (!m)
		return "";
	}
	m = m[0];
	var v = "";
	while (m!=v) {
		v = m;
		m = m.replace(/[\'\";]/g, "");
		m = m.replace(/&#/g, "&^#");
	}
	m = m.replace(/^[ ]/, "");
	m = m.replace(/[ ]$/, "");
	var i = m.search("=");
	return m.substring(i + 1);
}

function setArgumentsToToolBox(arg) {
	var par, FontSizeConst = new Array(8,10,12,14,16,18,20);
	if (!arg)
		arg = window.parent.argumentsVar;
	arg = arg.replace(/\"/g, "");
	window.parent.argumentsVar = arg;
	par = getValue("font", arg) + ",,,,,";  //comas = number of arrays - 1
	par = par.split(",");
	poem_font_name.options(0).text = "* " + par[0] + " *";
	poem_font_name.options(0).value = par[0];
	poem_font_name.selectedIndex = 0;
	par[1] = toNumber(par[1]);
	if (par[1]>= 1 && par[1] <= 7) par[1] = FontSizeConst[par[1]-1] ;
	poem_FontSize = par[1] + "pt";
	poem_font_size.value = toNumber(par[1]);
	poem_font_color.style.backgroundColor = par[2];
	poem_font_bold.style.backgroundColor = "";
	poem_font_italic.style.backgroundColor = "";
	poem_font_underline.style.backgroundColor = "";
	if (toNumber(par[3]))
		poem_font_bold.style.backgroundColor = highlightColor;
	if (toNumber(par[4]))
		poem_font_italic.style.backgroundColor = highlightColor;
	if (toNumber(par[5]))
		poem_font_underline.style.backgroundColor = highlightColor;
	par = getValue("bkcolor", arg);
	poem_background_color.style.backgroundColor = par;
	par = getValue("bkimage", arg);
	poem_background_image.value = par;
	if (getToolboxVar()==1) {
		drawTextEditor();
	}
	else {
		par = getValue("border", arg) + ",,,";
		par = par.split(",");
		poem_border_style.value = par[0];
		poem_border_size.value = toNumber(par[1]);
		poem_border_color.style.backgroundColor = par[2];
		par = getValue("num", arg) + ",,";
		par = par.split(",");
		poem_serial_num.value = toNumber(par[0]);
		poem_serial_color.style.backgroundColor = par[1];
		poem_serial_size.value = toNumber(par[2]);
		par = getValue("type", arg);
		par = toNumber(par);
		if (par<1 || par>3) par = 0;
		poem_style_twocolumns.style.backgroundColor = "";
		poem_style_overlap.style.backgroundColor = "";
		poem_style_stairs.style.backgroundColor = "";
		poem_style_onecolumn.style.backgroundColor = "";
		if (par==1)
			poem_style_overlap.style.backgroundColor = highlightColor;
		else if (par==2)
			poem_style_stairs.style.backgroundColor = highlightColor;
		else if (par==3)
			poem_style_onecolumn.style.backgroundColor = highlightColor;
		else
			poem_style_twocolumns.style.backgroundColor = highlightColor;
		par = getValue("brimage", arg);
		poem_break_image.value = par;
		par = getValue("width", arg);
		poem_border_width.value = toNumber(par);
		par = getValue("marginlr", arg);
		poem_border_marginlr.value = toNumber(par);
		par = getValue("margintb", arg);
		poem_border_margintb.value = toNumber(par);
		par = getValue("shadow", arg);
		par = toNumber(par);
		poem_Shadow = par;
		drawPoem();
	}
}

function toNumber(s) {
	s = parseInt(s);
	if (isNaN(s))
		s = 0;
	return s;
}

function setArgumentsFromToolBox() {
	var arg = "";
	arg = "font='" + poem_font_name.value + "," + poem_font_size.value + "," + poem_font_color.style.backgroundColor + "," + ifPressed(poem_font_bold, "1") + "," + ifPressed(poem_font_italic, "1") + "," + ifPressed(poem_font_underline, "1") + "'";
	arg += " bkcolor='" + poem_background_color.style.backgroundColor + "'";
	arg += " bkimage='" + poem_background_image.value + "'";
	if (getToolboxVar()==1) {
		arg += " brimage='" + getValue("brimage", window.parent.argumentsVar) + "'";
		arg += " border='" + getValue("border", window.parent.argumentsVar) + "'";
		arg += " shadow='" + getValue("shadow", window.parent.argumentsVar) + "'";
		arg += " marginlr='" + getValue("marginlr", window.parent.argumentsVar) + "'";
		arg += " margintb='" + getValue("margintb", window.parent.argumentsVar) + "'";
		arg += " width='" + getValue("width", window.parent.argumentsVar) + "'";
		arg += " num='" + getValue("num", window.parent.argumentsVar) + "'";
		arg += " type='" + getValue("type", window.parent.argumentsVar) + "'";
	}
	else {
		arg += " brimage='" + poem_break_image.value + "'";
		arg += " border='" + poem_border_style.value + "," + poem_border_size.value + "," + poem_border_color.style.backgroundColor + "'";
		arg += " shadow='" + toNumber(poem_border_shadow.value) + "'";
		arg += " width='" + toNumber(poem_border_width.value) + "'";
		arg += " marginlr='" + toNumber(poem_border_marginlr.value) + "'";
		arg += " margintb='" + toNumber(poem_border_margintb.value) + "'";
		arg += " num='" + toNumber(poem_serial_num.value) + "," + poem_serial_color.style.backgroundColor + "," + poem_serial_size.value + "'";
		if (poem_style_overlap.style.backgroundColor==highlightColor)
			arg += " type='1'";
		else if (poem_style_stairs.style.backgroundColor==highlightColor)
			arg += " type='2'";
		else if (poem_style_onecolumn.style.backgroundColor==highlightColor)
			arg += " type='3'";
		else
			arg += " type='0'";
	}
	window.parent.argumentsVar = arg;
}

function copy(ob) {
	var p = ob.value;
	ob.value = 0; //goto first item again
	if (p==1) { //code
		poemCopyTextBox.value = "<pre>" + window.parent.poemTextVar.replace(/<br>/g, "\n") + "</pre>";
		poemCopyTextBox.value += "<script>" + "doPoem(\"" + window.parent.argumentsVar + "\")" + "<" + "/script>";
		copyToClipboard();
	}
	else if (p==2) { //arguments
		poemCopyTextBox.value = "\"" + window.parent.argumentsVar + "\"";
		copyToClipboard();
	}
}

function copyToClipboard(t) {
	poemCopyTextBox.select();
	var sel = poemCopyTextBox.createTextRange();
	var r = sel.execCommand("copy");
	if (r) {
		alert("  ");
	}
	else {
		alert("   ");
	}
}

function chooseFontName(ob) {
	if (ob.selectedIndex==1) {
		var fn = window.prompt("  :", "");
		if (fn) {
			ob.options(0).text = "* " + fn + " *";
			ob.options(0).value = fn;
		}
	}
	else if (ob.selectedIndex>1) {
			ob.options(0).text = "* " + ob.options(ob.selectedIndex).text + " *";
			ob.options(0).value = ob.options(ob.selectedIndex).text;
	}
	ob.selectedIndex = 0;
}

function buttonToolClick(ob) {
	if (getToolboxVar()==1) {
		if (ob.style.backgroundColor=="") {
				ob.style.backgroundColor = highlightColor;
		}
		else {
				ob.style.backgroundColor = "";
		}
		drawTextEditor();
	}
	else {
		if (ob==poem_style_twocolumns || ob==poem_style_overlap || ob==poem_style_stairs  || ob==poem_style_onecolumn) {
			poem_style_twocolumns.style.backgroundColor = "";
			poem_style_overlap.style.backgroundColor = "";
			poem_style_stairs.style.backgroundColor = "";
			poem_style_onecolumn.style.backgroundColor = "";
			ob.style.backgroundColor = highlightColor;
		}
		else if (ob.style.backgroundColor=="") {
				ob.style.backgroundColor = highlightColor;
		}
		else {
				ob.style.backgroundColor = "";
		}
		drawPoem();
	}
}

function categoryMouseOver(ob, e) {
	if (e.offsetY<9)
		ob.src = "images/catup.gif";
	else
		ob.src = "images/catdown.gif";
}

function moveCategory(e) {
	var max = toolBoxCategory.options.length;
	var i = toolBoxCategory.selectedIndex;
	var d = ((e.offsetY<9)?-1:1);
	i += d;
	if (i<0)
		i = max - 1;
	else if (i>max-1)
		i = 0;
	toolBoxCategory.selectedIndex = i;
	showToolboxCategory(toolBoxCategory.value);
}

function showToolboxCategory(s) {
	if (getToolboxVar()==1)
		var ob = new Array("font", "background");
	else
		var ob = new Array("font", "background", "breakimage", "border", "serialnumber", "poemstyle");
	for (var i=0;i<ob.length;i++) {
		var o = eval("toolbox_" + ob[i]);
		if (ob[i]==s)
			o.style.display = "block";
		else
			o.style.display = "none";
	}
	toolBoxCategory.value = s;
}

function getOffset(o) {
	this.x = 0;
	this.y = 0;
	while (o) {
		if (o.offsetLeft>0)
			this.x += o.offsetLeft;
		this.y += o.offsetTop;
		o = o.offsetParent;
	}
}

function dec2hex(d) {
	var hD = "0123456789ABCDEF";
	var h = hD.substr(d&15, 1);
	while (d > 15){
		d >>= 4;
		h = hD.substr(d&15, 1) + h;
	}
	if (h.length == 1) h = "0" + h;
	return h;
}

function getColorCode(x, y, f) {
	var g, p, c, ix, iy, iz, x, y, k;
	g = Array("FFXX00", "XXFF00", "00FFXX", "00XXFF", "XX00FF", "FF00XX");
	p = 256 / 6;
	c = Math.floor(x / p);
	k = g[c];
	ix = (x % p) * 6;
	if (c % 2 == 1) ix = 255 - ix;
	if (f == 1) { // gradient to black
		iy = dec2hex(255 - y);
		k = k.replace(/FF/, iy);
		iz = Math.floor((ix / 255) * (255 - y));
	}
	else if (f == 2) { // gradient to white
		iy = dec2hex(y);
		k = k.replace(/00/, iy);
		iz = (y * (1 - ix / 255)) + ix;
	}
	iz = dec2hex(iz);
	k = k.replace(/XX/, iz);
	return "#" + k;
}

function getGrayScaleCode(y) {
	y = dec2hex(y);
	return "#" + y + y + y;
}

function setColorBoxHTML() {
	var c;
	colorBoxHTML = "<table id=palette dir=ltr border=0 bordercolor=whitesmoke bgcolor=white cellpadding=0 cellspacing=1 onmousedown=\"hidePalette(event)\" style=\"font-size:1pt\">";
	for (var y = 0; y < 13; y++) {
		colorBoxHTML += "<tr>";
		for (var x = 0; x < 12; x++) {
			if (y == 12) {
				c = getGrayScaleCode(255 - (255 / 11) * x);
				colorBoxHTML += "<td width=13 height=12 bgcolor=" + c + ">&nbsp;</td>";
			}
			else {
				c = getColorCode(x * 21.25, y * 16, 1);
				colorBoxHTML += "<td width=13 height=12 bgcolor=" + c + ">&nbsp;</td>";
			}
		}
		colorBoxHTML += "</tr>";
	}
	colorBoxHTML += "</table>";
}
setColorBoxHTML();

function showPalette(ob, e) {
	var win = window.parent.workspaceFrame.window;
	var offset = new getOffset(ob);
	win.colorboxSelected = ob;
	win.colorbox.innerHTML = colorBoxHTML;
	win.colorbox.style.left = offset.x - 160;
	win.colorbox.style.top = 0;
	win.colorbox.style.display = "block";
	win.palette.setCapture();
}

function execEditorTool(cmd, val) {
	var win = window.parent.workspaceFrame.window.editor.window;
	var rng = win.document;
	if (val)
		rng.execCommand(cmd, false, val);
	else
		rng.execCommand(cmd);
	win.focus();
}

function help() {
	//showModalDialog("help.htm", null,"help:no; center:yes; status:no; dialogHeight:450px; dialogWidth:580px");
	alert("   ");
}

function edit() {
	window.parent.poemTextVar = window.parent.poemTextVar.replace(/\n/gi,"<br>");
	window.parent.toolboxFrame.window.location.assign("toolbox_1.htm");
	window.parent.workspaceFrame.window.location.assign("edit.htm");
}

function show() {
	var h = window.parent.workspaceFrame.editor.window.document.body.innerHTML;
	h = h.replace(/<br>/gi, "\n");
	h = h.replace(/<p>/gi, "");
	h = h.replace(/<\/p>/gi, "");
	window.parent.poemTextVar = h;
	window.parent.toolboxFrame.window.location.assign("toolbox_2.htm");
	window.parent.workspaceFrame.window.location.assign("show.htm");
}

function drawTextEditor() {
	var b = window.parent.workspaceFrame.window.editor.window.document.body;
	b.style.fontFamily = poem_font_name.value;
	b.style.fontSize = poem_font_size.value + "pt";
	b.style.color = poem_font_color.style.backgroundColor;
	b.style.fontWeight = ifPressed(poem_font_bold, "bold", "normal");
	b.style.fontStyle = ifPressed(poem_font_italic, "italic", "normal");
	b.style.textDecoration = ifPressed(poem_font_underline, "underline", "none");
	b.style.backgroundColor = poem_background_color.style.backgroundColor;
	b.style.backgroundImage = "url(" + poem_background_image.value + ")";
	setArgumentsFromToolBox();
}

function drawPoem() {
	setArgumentsFromToolBox();
	window.parent.workspaceFrame.window.location.reload();
}

function printPoem() {
	window.parent.workspaceFrame.window.focus();
	window.print();
}

function inputArguments() {
	var arg = window.prompt("   :", window.parent.argumentsVar);
	if (arg)
		setArgumentsToToolBox(arg);
}

function restoreDefaultArguments() {
	var c = window.confirm("   .    ");
	if (c)
		setArgumentsToToolBox(window.parent.defaultArguments);
}

function getToolboxVar() {
	if (window.parent.toolboxFrame.window.location.href.search(/toolbox_1.htm/)!=-1)
		return 1;
	else
		return 2;
}